<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consulta de Chamados HelpDesk</title>
    
</head>
<body>
    <div class="container-fluid mt-4">
        <div class="card">
            <div class="card-body">
            
            <h1>Consulta de Chamados HelpDesk</h1>
            
            <div class="col-md-2">
                <form method="post" action="">
                    <div class="form-group">
                        <label for="id">Número do Chamado:</label>
                        <input type="number" id="id" name="id" class="form-control"  required placeholder="Digite o número do chamado">
                    </div>
                    <p></p>
                    <button type="submit" class="btn btn-primary btn-sm">Consultar</button>
                </form> 
            </div>
            
            <?php if ($_SERVER['REQUEST_METHOD'] == 'POST'): ?>
                    <div class="results" style="margin-top: 30px;">
                        <h2>Resultado da Consulta</h2>
                        
                        <?php
                        $id = $_POST['id'] ?? null;
                        
                        if ($id) {
                            try {
                                $dsn = 'mysql:host=localhost;dbname=erp;charset=utf8';
                                $conn = new PDO($dsn, 'geraldo', 'odlareg');
                                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                                
                                $sql = "SELECT id AS chamado FROM chamado WHERE id = :id";
                                $stmt = $conn->prepare($sql);
                                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                                $stmt->execute();
                                $result = $stmt->fetchAll();
                                
                                if (count($result) > 0) {
                                    echo '<div style="text-align: center; margin-top: 20px;">';
                                    echo '<p>Chamado encontrado:</p>';
                                    echo '<p style="font-size: 24px; font-weight: bold;">#' . $result[0]['chamado'] . '</p>';
                                    echo '<a href="modules/relatorios/relatorio_chamado.php?id=' . $result[0]['chamado'] . '" target="_blank">';
                                    echo '<button style="background-color: #2196F3; width: auto; padding: 10px 15px;" class="btn btn-primary btn-sm">Gerar Relatório PDF</button>';
                                    echo '</a>';
                                    echo '</div>';
                                } else {
                                    echo '<p style="color: #f44336; text-align: center;">Nenhum chamado encontrado com o número #' . htmlspecialchars($id) . '</p>';
                                }
                            } catch (PDOException $e) {
                                echo '<p style="color: #f44336;">Erro ao consultar: ' . htmlspecialchars($e->getMessage()) . '</p>';
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>