<!doctype html>
<html
  lang="en"
  class="layout-navbar-fixed layout-menu-fixed layout-compact"
  dir="ltr"
  data-skin="default"
  data-assets-path="assets/"
  data-template="vertical-menu-template"
  data-bs-theme="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Garantias - DataTable</title>
    <meta name="description" content="" />
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap"
      rel="stylesheet" />
    <link rel="stylesheet" href="assets/vendor/fonts/iconify-icons.css" />
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="assets/vendor/libs/pickr/pickr-themes.css" />
    <link rel="stylesheet" href="assets/vendor/css/core.css" />
    <link rel="stylesheet" href="assets/css/demo.css" />
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/flatpickr/flatpickr.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/@form-validation/form-validation.css" />
    <script src="assets/vendor/js/helpers.js"></script>
    <script src="assets/vendor/js/template-customizer.js"></script>
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
          <div class="content-wrapper">

            <div class="container-fluid flex-grow-1 container-p-y">
              <div class="card">
                <div class="card-header">
                  <h5 class="card-title">Lista de Garantias</h5>
                </div>
                <div class="card-datatable table-responsive pt-0">
                  <table id="garantias-table" class="datatables-basic table">
                    <thead>
                      <tr>
                        <th>Protocolo</th>
                        <th>Data</th>
                        <th>CódCli</th>
                        <th>Cliente</th>
                        <th>CódRCA</th>
                        <th>RCA</th>
                        <th>Responsável</th>
                        <th>Status</th>
                        <th>Ações</th>
                      </tr>
                    </thead>
                    <tbody>
                      <!-- Os dados serão carregados via AJAX -->
                    </tbody>
                  </table>
                </div>
              </div>
            </div>

        </div>
      </div>
    </div>

    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/libs/hammer/hammer.js"></script>
    <script src="assets/vendor/libs/i18n/i18n.js"></script>
    <script src="assets/vendor/js/menu.js"></script>
    <script src="assets/vendor/libs/datatables/jquery.dataTables.js"></script>
    <script src="assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
    <script src="assets/vendor/libs/moment/moment.js"></script>
    <script src="assets/vendor/libs/flatpickr/flatpickr.js"></script>
    <script src="assets/js/main.js"></script>
    
    <script>
    $(document).ready(function() {
      // Inicializa o DataTable
      var table = $('#garantias-table').DataTable({
        ajax: {
          url: 'http://192.168.0.158:90/garantia-new-version/backend/routers/garantias',
          dataSrc: 'data' // Especifica o caminho para o array de dados na resposta
        },
        columns: [
          { data: 'protocolo' },
          { data: 'dt_cad' },
          { data: 'CODCLI' },
          { data: 'CLIENTE' },
          { data: 'CODUSUR' },
          { data: 'NOME' },
          { data: 'responsavel' },
          { 
            data: 'status',
            render: function(data, type, row) {
              // Adiciona classes CSS diferentes baseadas no status
              var badgeClass = '';
              if (data === 'Aberto') {
                badgeClass = 'badge bg-label-primary';
              } else if (data === 'Em Digitacao') {
                badgeClass = 'badge bg-label-warning';
              } else {
                badgeClass = 'badge bg-label-secondary';
              }
              return '<span class="' + badgeClass + '">' + data + '</span>';
            }
          },
          {
            data: null,
            render: function(data, type, row) {
              // Botões de ação
              return '<div class="d-flex">' +
                '<a href="javascript:;" class="text-body dropdown-toggle hide-arrow" data-bs-toggle="dropdown">' +
                  '<i class="icon-base ti ti-dots-vertical"></i>' +
                '</a>' +
                '<div class="dropdown-menu dropdown-menu-end">' +
                  '<a href="javascript:;" class="dropdown-item">Editar</a>' +
                  '<a href="javascript:;" class="dropdown-item">Excluir</a>' +
                '</div>' +
              '</div>';
            },
            orderable: false
          }
        ],
        dom: '<"card-header pb-0 pt-md-0"<"head-label"><"d-flex justify-content-md-end justify-content-center"f>>t<"row mx-2"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
        displayLength: 10,
        lengthMenu: [7, 10, 25, 50, 75, 100],
        responsive: true,
        language: {
          url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' // Tradução para português
        }
      });

      // Adiciona label no cabeçalho
      $('div.head-label').html('<h5 class="card-title mb-0">Lista de Garantias</h5>');
    });
    </script>
  </body>
</html>