<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type");

// Conex�o com o .env
$dotenv = parse_ini_file(__DIR__ . '../../.env');
$dbHost = $dotenv['DB_HOST'];
$dbUser = $dotenv['DB_USER'];
$dbPass = $dotenv['DB_PASSWORD'];
$dbName = $dotenv['DB_NAME'];

// Conex�o com o banco de dados
try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Falha na conex�o com o banco de dados: ' . $e->getMessage()]);
    exit;
}

// Roteamento
$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

// Verifica se o script est� sendo acessado diretamente
if (basename($_SERVER['SCRIPT_FILENAME']) === 'contrato.php') {
    switch ($method) {
        case 'GET':
            if ($id) {
                getContrato($pdo, $id);
            } else {
                getAllContratos($pdo);
            }
            break;
        case 'POST':
            createContrato($pdo);
            break;
        case 'PUT':
            if ($id) {
                updateContrato($pdo, $id);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'ID do contrato n�o especificado']);
            }
            break;
        case 'DELETE':
            if ($id) {
                deleteContrato($pdo, $id);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'ID do contrato n�o especificado']);
            }
            break;
        default:
            http_response_code(405);
            echo json_encode(['error' => 'M�todo n�o permitido']);
    }
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Endpoint n�o encontrado']);
}

// Fun��es CRUD

function getAllContratos($pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM contrato");
        $contratos = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($contratos);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao buscar contratos: ' . $e->getMessage()]);
    }
}

function getContrato($pdo, $id) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM contrato WHERE id = ?");
        $stmt->execute([$id]);
        $contrato = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($contrato) {
            echo json_encode($contrato);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Contrato n�o encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao buscar contrato: ' . $e->getMessage()]);
    }
}

function createContrato($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        http_response_code(400);
        echo json_encode(['error' => 'Dados inv�lidos']);
        return;
    }
    
    if (!isset($data['fk_cliente'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_cliente" faltando']);
        return;
    }

    if (!isset($data['fk_vendedor'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_vendedor" faltando']);
        return;
    }

    if (!isset($data['fk_faturista'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_faturista" faltando']);
        return;
    }

    if (!isset($data['fk_tp_contrato'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_tp_contrato" faltando']);
        return;
    }

    if (!isset($data['dt_vencimento'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "dt_vencimento" faltando']);
        return;
    }
    if (strlen($data['dt_vencimento']) > 2) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "dt_vencimento" deve ter no m�ximo 2 caracteres']);
        return;
    }

    if (!isset($data['prazo'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "prazo" faltando']);
        return;
    }
    if (strlen($data['prazo']) > 10) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "prazo" deve ter no m�ximo 10 caracteres']);
        return;
    }

    if (!isset($data['outros_especificar'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "outros_especificar" faltando']);
        return;
    }
    if (strlen($data['outros_especificar']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "outros_especificar" deve ter no m�ximo 50 caracteres']);
        return;
    }

    if (!isset($data['anexo'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "anexo" faltando']);
        return;
    }
    if (strlen($data['anexo']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "anexo" deve ter no m�ximo 255 caracteres']);
        return;
    }


    try {
        $sql = "INSERT INTO contrato (`fk_cliente`, `fk_vendedor`, `fk_faturista`, `fk_tp_contrato`, `dt_vencimento`, `prazo`, `outros_especificar`, `anexo`) VALUES (:fk_cliente, :fk_vendedor, :fk_faturista, :fk_tp_contrato, :dt_vencimento, :prazo, :outros_especificar, :anexo)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':fk_cliente' => $data['fk_cliente'], ':fk_vendedor' => $data['fk_vendedor'], ':fk_faturista' => $data['fk_faturista'], ':fk_tp_contrato' => $data['fk_tp_contrato'], ':dt_vencimento' => $data['dt_vencimento'], ':prazo' => $data['prazo'], ':outros_especificar' => $data['outros_especificar'], ':anexo' => $data['anexo']
        ]);
        
        $id = $pdo->lastInsertId();
        http_response_code(201);
        echo json_encode(['id' => $id, 'message' => 'Contrato criado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao criar contrato: ' . $e->getMessage()]);
    }
}

function updateContrato($pdo, $id) {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        http_response_code(400);
        echo json_encode(['error' => 'Dados inv�lidos']);
        return;
    }
    
    if (!isset($data['fk_cliente'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_cliente" faltando']);
        return;
    }

    if (!isset($data['fk_vendedor'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_vendedor" faltando']);
        return;
    }

    if (!isset($data['fk_faturista'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_faturista" faltando']);
        return;
    }

    if (!isset($data['fk_tp_contrato'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fk_tp_contrato" faltando']);
        return;
    }

    if (!isset($data['dt_vencimento'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "dt_vencimento" faltando']);
        return;
    }
    if (strlen($data['dt_vencimento']) > 2) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "dt_vencimento" deve ter no m�ximo 2 caracteres']);
        return;
    }

    if (!isset($data['prazo'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "prazo" faltando']);
        return;
    }
    if (strlen($data['prazo']) > 10) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "prazo" deve ter no m�ximo 10 caracteres']);
        return;
    }

    if (!isset($data['outros_especificar'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "outros_especificar" faltando']);
        return;
    }
    if (strlen($data['outros_especificar']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "outros_especificar" deve ter no m�ximo 50 caracteres']);
        return;
    }

    if (!isset($data['anexo'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "anexo" faltando']);
        return;
    }
    if (strlen($data['anexo']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "anexo" deve ter no m�ximo 255 caracteres']);
        return;
    }


    try {
        // Verifica se o contrato existe
        $check = $pdo->prepare("SELECT id FROM contrato WHERE id = ?");
        $check->execute([$id]);
        
        if (!$check->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Contrato n�o encontrado']);
            return;
        }
        
        $sql = "UPDATE contrato SET `fk_cliente` = :fk_cliente, `fk_vendedor` = :fk_vendedor, `fk_faturista` = :fk_faturista, `fk_tp_contrato` = :fk_tp_contrato, `dt_vencimento` = :dt_vencimento, `prazo` = :prazo, `outros_especificar` = :outros_especificar, `anexo` = :anexo WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':fk_cliente' => $data['fk_cliente'], ':fk_vendedor' => $data['fk_vendedor'], ':fk_faturista' => $data['fk_faturista'], ':fk_tp_contrato' => $data['fk_tp_contrato'], ':dt_vencimento' => $data['dt_vencimento'], ':prazo' => $data['prazo'], ':outros_especificar' => $data['outros_especificar'], ':anexo' => $data['anexo'], ':id' => $id
        ]);
        
        echo json_encode(['message' => 'Contrato atualizado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao atualizar contrato: ' . $e->getMessage()]);
    }
}

function deleteContrato($pdo, $id) {
    try {
        // Verifica se o contrato existe
        $check = $pdo->prepare("SELECT id FROM contrato WHERE id = ?");
        $check->execute([$id]);
        
        if (!$check->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Contrato n�o encontrado']);
            return;
        }
        
        $stmt = $pdo->prepare("DELETE FROM contrato WHERE id = ?");
        $stmt->execute([$id]);
        
        echo json_encode(['message' => 'Contrato deletado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao deletar contrato: ' . $e->getMessage()]);
    }
}
?>